<?php

namespace App\Http\Controllers;

use App\Services\FinanceiroService;

class FinanceiroController extends Controller
{
    public function __construct(private FinanceiroService $service)
    {
        $this->middleware(function ($request, $next) {
            $this->requireRole(['admin']);
            return $next($request);
        });
    }

    public function index()
    {
        return response()->json($this->service->resumo());
    }
}
