<?php

namespace App\Http\Controllers;

use App\Services\JuridicoService;

class JuridicoController extends Controller
{
    public function __construct(private JuridicoService $service)
    {
        $this->middleware(function ($request, $next) {
            $this->requireRole(['admin', 'gestor']);
            return $next($request);
        });
    }

    public function index()
    {
        return response()->json($this->service->painel());
    }
}
