<?php

namespace App\Http\Controllers;

use App\Models\Usuario;
use Illuminate\Http\Request;

class UsuarioController extends Controller
{
    public function __construct()
    {
        $this->middleware(function ($request, $next) {
            $this->requireRole(['admin']);
            return $next($request);
        });
    }

    public function index()
    {
        return response()->json(Usuario::query()->paginate(20));
    }

    public function store(Request $request)
    {
        $usuario = Usuario::query()->create($request->all());
        return response()->json($usuario, 201);
    }

    public function show(int $id)
    {
        return response()->json(Usuario::query()->findOrFail($id));
    }

    public function edit(int $id)
    {
        return response()->json(Usuario::query()->findOrFail($id));
    }

    public function update(Request $request, int $id)
    {
        $usuario = Usuario::query()->findOrFail($id);
        $usuario->update($request->all());
        return response()->json($usuario);
    }

    public function destroy(int $id)
    {
        Usuario::query()->whereKey($id)->delete();
        return response()->noContent();
    }
}
