<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;

class CheckRole
{
    public function handle(Request $request, Closure $next, ...$roles)
    {
        $user = $request->user();
        $role = strtolower(trim((string) ($user->role ?? '')));
        $allowed = array_map(static fn ($value) => strtolower(trim((string) $value)), $roles);
        if (!$role || !in_array($role, $allowed, true)) {
            abort(403, 'Acesso negado.');
        }

        return $next($request);
    }
}
