<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ContaReceber extends Model
{
    protected $fillable = ['descricao', 'valor', 'data_vencimento', 'status', 'usuario_id', 'contrato_credito_id', 'conta_bancaria_id'];

    public function usuario()
    {
        return $this->belongsTo(Usuario::class);
    }

    public function contratoCredito()
    {
        return $this->belongsTo(ContratoCredito::class);
    }

    public function contaBancaria()
    {
        return $this->belongsTo(ContaBancaria::class);
    }

}

