<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class IndexadorHistorico extends Model
{
    protected $fillable = ['contrato_credito_id', 'indexador', 'valor', 'data_referencia'];

    public function contratoCredito()
    {
        return $this->belongsTo(ContratoCredito::class);
    }

    public function contratoIndexadors()
    {
        return $this->hasMany(ContratoIndexador::class);
    }

}

