<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Parceiro extends Model
{
    protected $table = 'parceiros';

    protected $fillable = [
        'nome',
        'tipo',
        'cnpj',
        'canal_envio',
        'tipo_integracao',
        'contato_nome',
        'contato_email',
        'contato_telefone',
        'api_url',
        'api_base_url',
        'api_auth_url',
        'api_client_id',
        'api_client_secret',
        'api_scope',
        'api_audience',
        'api_token',
        'api_token_expires_at',
        'api_key',
        'api_headers',
        'api_payload_map',
        'api_enabled',
        'ativo',
    ];

    protected $casts = [
        'api_enabled' => 'boolean',
        'ativo' => 'boolean',
        'api_token_expires_at' => 'datetime',
    ];
}
