<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

class Usuario extends Authenticatable
{
    use HasApiTokens;
    use HasFactory;
    use Notifiable;

    protected $table = 'users';

    protected $hidden = ['password', 'remember_token'];

    protected $fillable = ['name', 'email', 'password', 'perfil_acesso_id', 'role', 'ativo', 'telefone'];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'password' => 'hashed',
        'ativo' => 'boolean',
    ];

    public function perfilAcesso()
    {
        return $this->belongsTo(PerfilAcesso::class);
    }

    public function imovelAvaliacoes()
    {
        return $this->hasMany(ImovelAvaliacao::class);
    }

    public function vistorias()
    {
        return $this->hasMany(Vistoria::class);
    }

    public function propostaCreditos()
    {
        return $this->hasMany(PropostaCredito::class);
    }

    public function historicosStatus()
    {
        return $this->hasMany(PropostaHistoricoStatus::class);
    }

    public function contratoAssinaturas()
    {
        return $this->hasMany(ContratoAssinatura::class);
    }

    public function contasPagar()
    {
        return $this->hasMany(ContaPagar::class);
    }

    public function contasReceber()
    {
        return $this->hasMany(ContaReceber::class);
    }

    public function historicosCompliance()
    {
        return $this->hasMany(HistoricoCompliance::class);
    }

    public function tarefasOperacionais()
    {
        return $this->hasMany(TarefaOperacional::class);
    }

    public function workflowHistoricos()
    {
        return $this->hasMany(WorkflowHistorico::class);
    }

    public function atendimentos()
    {
        return $this->hasMany(Atendimento::class);
    }

    public function chamadosSuporte()
    {
        return $this->hasMany(ChamadoSuporte::class);
    }

    public function indicadoresCredito()
    {
        return $this->hasMany(IndicadorCredito::class);
    }

    public function indicadoresImobiliarios()
    {
        return $this->hasMany(IndicadorImobiliario::class);
    }

    public function indicadoresRisco()
    {
        return $this->hasMany(IndicadorRisco::class);
    }

    public function logsSistema()
    {
        return $this->hasMany(LogSistema::class);
    }

    public function auditorias()
    {
        return $this->hasMany(Auditoria::class);
    }

    public function leads()
    {
        return $this->hasMany(Lead::class, 'responsavel_id');
    }

}

