<?php

namespace App\Services;

use App\Models\Lead;

class LeadService
{
    private const FLOW = [
        'novo' => ['contato'],
        'contato' => ['qualificacao'],
        'qualificacao' => ['proposta'],
        'proposta' => ['convertido', 'perdido'],
        'convertido' => [],
        'perdido' => [],
    ];

    public function transition(Lead $lead, string $nextStatus): Lead
    {
        $current = $lead->status;
        $allowed = self::FLOW[$current] ?? [];

        if (!in_array($nextStatus, $allowed, true)) {
            throw new \InvalidArgumentException('Transicao invalida.');
        }

        $lead->status = $nextStatus;
        $lead->save();

        return $lead;
    }

    public function assignResponsavel(Lead $lead, int $usuarioId): Lead
    {
        $lead->responsavel_id = $usuarioId;
        $lead->save();

        return $lead;
    }

    public function convertToProposta(Lead $lead): Lead
    {
        $lead->status = 'convertido';
        $lead->save();

        return $lead;
    }
}
