<?php

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'role' => \App\Http\Middleware\CheckRole::class,
        ]);
        $middleware->validateCsrfTokens(except: [
            'propostas/solicitacoes/*/upload',
            'contratos/solicitacoes/*/upload',
            'adm_capital/api/propostas/solicitacoes/*/upload',
            'adm_capital/api/contratos/solicitacoes/*/upload',
        ]);
    })
    ->withSchedule(function (Schedule $schedule) {
        $schedule->command('agenda:lembretes')->everyMinute();
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();