<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('propostas_credito')) {
            return;
        }

        $columns = [];
        foreach (['documentacao_at', 'vistoria_at', 'avaliacao_at', 'comite_at'] as $column) {
            if (!Schema::hasColumn('propostas_credito', $column)) {
                $columns[] = $column;
            }
        }

        if (!$columns) {
            return;
        }

        Schema::table('propostas_credito', function (Blueprint $table) use ($columns) {
            if (in_array('documentacao_at', $columns, true)) {
                $table->dateTime('documentacao_at')->nullable();
            }
            if (in_array('vistoria_at', $columns, true)) {
                $table->dateTime('vistoria_at')->nullable();
            }
            if (in_array('avaliacao_at', $columns, true)) {
                $table->dateTime('avaliacao_at')->nullable();
            }
            if (in_array('comite_at', $columns, true)) {
                $table->dateTime('comite_at')->nullable();
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('propostas_credito')) {
            return;
        }

        $columns = [];
        foreach (['documentacao_at', 'vistoria_at', 'avaliacao_at', 'comite_at'] as $column) {
            if (Schema::hasColumn('propostas_credito', $column)) {
                $columns[] = $column;
            }
        }

        if (!$columns) {
            return;
        }

        Schema::table('propostas_credito', function (Blueprint $table) use ($columns) {
            $table->dropColumn($columns);
        });
    }
};
