<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('contrato_documentos')) {
            return;
        }

        Schema::create('contrato_documentos', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('contrato_id');
            $table->string('tipo', 120)->nullable();
            $table->string('arquivo', 255);
            $table->string('status', 40)->nullable();
            $table->timestamps();

            $table->index('contrato_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('contrato_documentos');
    }
};
