<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('agenda_evento_participantes')) {
            return;
        }

        Schema::create('agenda_evento_participantes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('evento_id');
            $table->unsignedBigInteger('usuario_id');
            $table->string('status', 20)->default('pendente');
            $table->dateTime('respondido_em')->nullable();
            $table->boolean('lembrete_sms')->default(true);
            $table->timestamps();

            $table->index('evento_id');
            $table->index('usuario_id');
            $table->unique(['evento_id', 'usuario_id']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('agenda_evento_participantes');
    }
};
