<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('agenda_evento_lembretes')) {
            return;
        }

        Schema::create('agenda_evento_lembretes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('evento_id');
            $table->string('destinatario_tipo', 20);
            $table->unsignedBigInteger('destinatario_id')->nullable();
            $table->string('destinatario_telefone', 40)->nullable();
            $table->dateTime('enviar_em');
            $table->dateTime('enviado_em')->nullable();
            $table->string('status', 20)->default('pendente');
            $table->unsignedSmallInteger('tentativas')->default(0);
            $table->text('erro_ultima')->nullable();
            $table->timestamps();

            $table->index('evento_id');
            $table->index('destinatario_id');
            $table->index('enviar_em');
            $table->index('status');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('agenda_evento_lembretes');
    }
};
