<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('parceiros', function (Blueprint $table) {
            if (!Schema::hasColumn('parceiros', 'cnpj')) {
                $table->string('cnpj', 30)->nullable()->after('tipo');
            }
            if (!Schema::hasColumn('parceiros', 'tipo_integracao')) {
                $table->string('tipo_integracao', 60)->nullable()->after('canal_envio');
            }
            if (!Schema::hasColumn('parceiros', 'api_base_url')) {
                $table->string('api_base_url', 255)->nullable()->after('api_url');
            }
            if (!Schema::hasColumn('parceiros', 'api_auth_url')) {
                $table->string('api_auth_url', 255)->nullable()->after('api_base_url');
            }
            if (!Schema::hasColumn('parceiros', 'api_client_id')) {
                $table->string('api_client_id', 255)->nullable()->after('api_auth_url');
            }
            if (!Schema::hasColumn('parceiros', 'api_client_secret')) {
                $table->string('api_client_secret', 255)->nullable()->after('api_client_id');
            }
            if (!Schema::hasColumn('parceiros', 'api_scope')) {
                $table->string('api_scope', 255)->nullable()->after('api_client_secret');
            }
            if (!Schema::hasColumn('parceiros', 'api_audience')) {
                $table->string('api_audience', 255)->nullable()->after('api_scope');
            }
            if (!Schema::hasColumn('parceiros', 'api_token_expires_at')) {
                $table->dateTime('api_token_expires_at')->nullable()->after('api_token');
            }
            if (!Schema::hasColumn('parceiros', 'api_payload_map')) {
                $table->text('api_payload_map')->nullable()->after('api_headers');
            }
            if (!Schema::hasColumn('parceiros', 'api_enabled')) {
                $table->boolean('api_enabled')->default(false)->after('api_payload_map');
            }
        });
    }

    public function down(): void
    {
        Schema::table('parceiros', function (Blueprint $table) {
            $columns = [
                'cnpj',
                'tipo_integracao',
                'api_base_url',
                'api_auth_url',
                'api_client_id',
                'api_client_secret',
                'api_scope',
                'api_audience',
                'api_token_expires_at',
                'api_payload_map',
                'api_enabled',
            ];

            foreach ($columns as $column) {
                if (Schema::hasColumn('parceiros', $column)) {
                    $table->dropColumn($column);
                }
            }
        });
    }
};