<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\DashboardController;
use App\Http\Controllers\PessoaFisicaController;
use App\Http\Controllers\PessoaJuridicaController;
use App\Http\Controllers\ImovelController;
use App\Http\Controllers\PropostaCreditoController;
use App\Http\Controllers\PropostaDocumentosController;
use App\Http\Controllers\ContratoCreditoController;
use App\Http\Controllers\ContratoDocumentosController;
use App\Http\Controllers\LeadController;
use App\Http\Controllers\ClienteController;
use App\Http\Controllers\UsuarioController;
use App\Http\Controllers\FinanceiroController;
use App\Http\Controllers\JuridicoController;
use App\Http\Controllers\OperacionalController;
use App\Http\Controllers\ComplianceController;
use App\Http\Controllers\ConfiguracoesController;
use App\Http\Controllers\ParceiroController;
use App\Http\Controllers\AgendaController;
use App\Http\Controllers\AgendaParticipanteController;
use App\Http\Controllers\AgendaMensagemController;
use App\Http\Controllers\ExternalFormController;

Route::get('/', [AuthController::class, 'login'])->name('login');
Route::get('/csrf', [AuthController::class, 'csrf']);
Route::get('/me', [AuthController::class, 'me'])->middleware('auth');
Route::post('/login', [AuthController::class, 'authenticate']);
Route::post('/logout', [AuthController::class, 'logout']);

Route::get('/propostas/solicitacoes/{token}', [PropostaDocumentosController::class, 'show']);
Route::post('/propostas/solicitacoes/{token}/upload', [PropostaDocumentosController::class, 'upload']);
Route::get('/contratos/solicitacoes/{token}', [ContratoDocumentosController::class, 'show']);
Route::post('/contratos/solicitacoes/{token}/upload', [ContratoDocumentosController::class, 'upload']);

Route::middleware(['auth'])->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index']);

    Route::resource('pessoas-fisicas', PessoaFisicaController::class);
    Route::resource('pessoas-juridicas', PessoaJuridicaController::class);
    Route::resource('clientes', ClienteController::class);
    Route::resource('usuarios', UsuarioController::class);
    Route::resource('imoveis', ImovelController::class);
    Route::get('/propostas/status', [PropostaCreditoController::class, 'statusOptions']);
    Route::resource('propostas', PropostaCreditoController::class);
    Route::get('/propostas/sugestao/{cliente}', [PropostaCreditoController::class, 'suggest'])->whereNumber('cliente');
    Route::post('/propostas/{proposta}/solicitacao-documentos', [PropostaDocumentosController::class, 'store']);
    Route::patch('/propostas/{proposta}/documentos/{documento}/validacao', [PropostaDocumentosController::class, 'updateValidacao']);
    Route::post('/propostas/{proposta}/solicitacao-documentos-contrato', [ContratoDocumentosController::class, 'storeFromProposta']);
    Route::post('/propostas/{proposta}/enviar-parceiro', [PropostaCreditoController::class, 'enviarParceiro']);
    Route::get('/propostas/{proposta}/compliance', [ComplianceController::class, 'list']);
    Route::get('/propostas/{proposta}/compliance/resumo', [ComplianceController::class, 'resumo']);
    Route::post('/propostas/{proposta}/compliance', [ComplianceController::class, 'validarProposta']);
    Route::post('/propostas/{proposta}/documentos/{documento}/compliance', [ComplianceController::class, 'validarDocumento']);
    Route::resource('contratos', ContratoCreditoController::class);
    Route::get('/leads/external', [LeadController::class, 'externalIndex']);
    Route::get('/leads/external/disponiveis', [LeadController::class, 'availableForPropostas']);
    Route::post('/leads/external/{externalId}/import', [LeadController::class, 'importExternal'])->whereNumber('externalId');
    Route::post('/leads/external/{externalId}/email', [LeadController::class, 'sendExternalEmail'])->whereNumber('externalId');
    Route::post('/leads/external-form/upload', [ExternalFormController::class, 'upload']);
    Route::post('/leads/external-form/{form}', [ExternalFormController::class, 'store']);
    Route::resource('leads', LeadController::class)->whereNumber('lead');
    Route::patch('/leads/{lead}/status', [LeadController::class, 'updateStatus']);
    Route::post('/leads/{lead}/assign', [LeadController::class, 'assignResponsavel']);
    Route::post('/leads/{lead}/convert', [LeadController::class, 'convertToProposta']);

    Route::get('/financeiro', [FinanceiroController::class, 'index']);
    Route::get('/juridico', [JuridicoController::class, 'index']);
    Route::get('/operacional', [OperacionalController::class, 'index']);
    Route::get('/compliance', [ComplianceController::class, 'index']);
    Route::get('/configuracoes/whatsapp', [ConfiguracoesController::class, 'showWhatsapp']);
    Route::put('/configuracoes/whatsapp', [ConfiguracoesController::class, 'updateWhatsapp']);
    Route::get('/configuracoes', [ConfiguracoesController::class, 'index']);
    Route::put('/configuracoes', [ConfiguracoesController::class, 'update']);
    Route::resource('parceiros', ParceiroController::class);

    Route::get('/agenda/estatisticas', [AgendaController::class, 'stats']);
    Route::get('/agenda/export', [AgendaController::class, 'export']);
    Route::get('/agenda/usuarios', [AgendaController::class, 'usuarios']);
    Route::get('/agenda/clientes', [AgendaController::class, 'clientes']);
    Route::get('/agenda', [AgendaController::class, 'index']);
    Route::post('/agenda', [AgendaController::class, 'store']);
    Route::get('/agenda/{agenda}', [AgendaController::class, 'show']);
    Route::put('/agenda/{agenda}', [AgendaController::class, 'update']);
    Route::delete('/agenda/{agenda}', [AgendaController::class, 'destroy']);
    Route::post('/agenda/{agenda}/participantes', [AgendaParticipanteController::class, 'store']);
    Route::patch('/agenda/{agenda}/participantes/{participante}', [AgendaParticipanteController::class, 'update']);
    Route::delete('/agenda/{agenda}/participantes/{participante}', [AgendaParticipanteController::class, 'destroy']);
    Route::get('/agenda/{agenda}/mensagens', [AgendaMensagemController::class, 'index']);
    Route::post('/agenda/{agenda}/mensagens', [AgendaMensagemController::class, 'store']);
});

require __DIR__.'/breeze_auth.php';
