<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\PropostaService;

class PropostaCreditoController extends Controller
{
    public function __construct(private PropostaService $propostaService) {}

    public function index()
    {
        return response()->json($this->propostaService->list());
    }

    public function store(Request $request)
    {
        return response()->json($this->propostaService->create($request->all()), 201);
    }

    public function show(string $id)
    {
        return response()->json($this->propostaService->find($id));
    }

    public function update(Request $request, string $id)
    {
        return response()->json($this->propostaService->update($id, $request->all()));
    }

    public function destroy(string $id)
    {
        $this->propostaService->delete($id);
        return response()->json(['message' => 'Proposta removida']);
    }
}
