<?php

namespace App\Services;

use App\Models\ContratoCredito;

class ContratoService
{
    public function list()
    {
        return ContratoCredito::with(['proposta'])->latest()->paginate();
    }

    public function find(string $id)
    {
        return ContratoCredito::with(['proposta'])->findOrFail($id);
    }

    public function create(array $data)
    {
        return ContratoCredito::create($data);
    }

    public function update(string $id, array $data)
    {
        $contrato = ContratoCredito::findOrFail($id);
        $contrato->update($data);
        return $contrato;
    }

    public function delete(string $id): void
    {
        ContratoCredito::findOrFail($id)->delete();
    }
}
