<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\PessoaFisica;

class PessoaFisicaController extends Controller
{
    public function index()
    {
        return response()->json(PessoaFisica::paginate());
    }

    public function store(Request $request)
    {
        $pessoa = PessoaFisica::create($request->all());
        return response()->json($pessoa, 201);
    }

    public function show(string $id)
    {
        return response()->json(PessoaFisica::with(['enderecos','contatos'])->findOrFail($id));
    }

    public function update(Request $request, string $id)
    {
        $pessoa = PessoaFisica::findOrFail($id);
        $pessoa->update($request->all());
        return response()->json($pessoa);
    }

    public function destroy(string $id)
    {
        PessoaFisica::findOrFail($id)->delete();
        return response()->json(['message' => 'Registro removido']);
    }
}
