<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ImovelGarantia extends Model
{
    use HasFactory;

    protected $fillable = [
        'imovel_id',
        'contrato_id',
        'tipo',
        'status',
    ];

    public function imovel()
    {
        return $this->belongsTo(Imovel::class);
    }

    public function contrato()
    {
        return $this->belongsTo(ContratoCredito::class, 'contrato_id');
    }
}
