<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PessoaFisica extends Model
{
    use HasFactory;

    protected $fillable = [
        'nome',
        'cpf',
        'rg',
        'data_nascimento',
        'estado_civil',
        'profissao',
        'renda',
    ];

    public function enderecos()
    {
        return $this->morphMany(Endereco::class, 'enderecavel');
    }

    public function contatos()
    {
        return $this->morphMany(Contato::class, 'contatavel');
    }

    public function propostas()
    {
        return $this->hasMany(PropostaCredito::class, 'pessoa_fisica_id');
    }
}
