<?php

namespace App\Http\Controllers;

use App\Models\Cliente;
use App\Models\PessoaJuridica;
use Illuminate\Http\Request;

class PessoaJuridicaController extends Controller
{
    public function index()
    {
        $pessoas = PessoaJuridica::query()
            ->with('cliente')
            ->orderByDesc('cliente_id')
            ->paginate(20);

        return response()->json($pessoas);
    }

    public function create()
    {
        return response()->json(['message' => 'create']);
    }

    public function store(Request $request)
    {
        $clienteId = $this->resolveCliente($request, 'PJ');

        $registro = PessoaJuridica::query()->create(array_merge(
            $request->only([
                'cnpj',
                'data_abertura',
                'ramo_atuacao',
                'faturamento_anual',
                'renda',
                'estado_civil_socio',
                'conjuge_nome',
            ]),
            ['cliente_id' => $clienteId]
        ));

        return response()->json($registro->load('cliente'), 201);
    }

    public function show(int $id)
    {
        $pessoa = PessoaJuridica::query()
            ->with('cliente')
            ->findOrFail($id);

        return response()->json($pessoa);
    }

    public function edit(int $id)
    {
        return response()->json(PessoaJuridica::query()->findOrFail($id));
    }

    public function update(Request $request, int $id)
    {
        $registro = PessoaJuridica::query()->findOrFail($id);
        $registro->update($request->only([
            'cnpj',
            'data_abertura',
            'ramo_atuacao',
            'faturamento_anual',
            'renda',
            'estado_civil_socio',
            'conjuge_nome',
        ]));

        $clienteData = $request->only([
            'nome_razao',
            'cpf_cnpj',
            'data_nascimento',
            'estado_civil',
            'renda',
            'usuario_responsavel',
            'status',
        ]);
        if (array_filter($clienteData)) {
            $registro->cliente()->update($clienteData);
        }

        return response()->json($registro->load('cliente'));
    }

    public function destroy(int $id)
    {
        PessoaJuridica::query()->whereKey($id)->delete();
        return response()->noContent();
    }

    private function resolveCliente(Request $request, string $tipo): int
    {
        $clienteId = $request->input('cliente_id');
        if ($clienteId) {
            return (int) $clienteId;
        }

        $payload = $request->only([
            'nome_razao',
            'cpf_cnpj',
            'data_nascimento',
            'estado_civil',
            'renda',
            'usuario_responsavel',
            'status',
        ]);

        if (empty($payload['nome_razao']) && $request->filled('razao_social')) {
            $payload['nome_razao'] = $request->input('razao_social');
        }
        if (empty($payload['cpf_cnpj']) && $request->filled('cnpj')) {
            $payload['cpf_cnpj'] = $request->input('cnpj');
        }

        $payload['tipo_cliente'] = $tipo;

        $cliente = Cliente::query()->create($payload);

        return (int) $cliente->id;
    }
}
