<?php

namespace App\Http\Controllers;

use App\Services\FinanceiroService;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class FinanceiroController extends Controller
{
    public function __construct(private FinanceiroService $service)
    {
    }

    public function index()
    {
        return response()->json($this->service->resumo());
    }

    public function contasReceber()
    {
        if (!Schema::hasTable('financeiro_contas_receber')) {
            return response()->json(['data' => []]);
        }

        $items = DB::table('financeiro_contas_receber')
            ->orderByDesc('vencimento')
            ->orderByDesc('id')
            ->limit(200)
            ->get();

        return response()->json(['data' => $items]);
    }

    public function contasPagar()
    {
        if (!Schema::hasTable('financeiro_contas_pagar')) {
            return response()->json(['data' => []]);
        }

        $items = DB::table('financeiro_contas_pagar')
            ->orderByDesc('vencimento')
            ->orderByDesc('id')
            ->limit(200)
            ->get();

        return response()->json(['data' => $items]);
    }

    public function movimentacoes()
    {
        if (!Schema::hasTable('financeiro_movimentacoes')) {
            return response()->json(['data' => []]);
        }

        $items = DB::table('financeiro_movimentacoes')
            ->orderByDesc('data')
            ->orderByDesc('id')
            ->limit(200)
            ->get();

        return response()->json(['data' => $items]);
    }

    public function storeContaReceber(Request $request)
    {
        if (!Schema::hasTable('financeiro_contas_receber')) {
            return response()->json(['message' => 'Tabela financeiro_contas_receber nao encontrada.'], 422);
        }

        $payload = $request->validate([
            'cliente' => ['nullable', 'string', 'max:150'],
            'descricao' => ['required', 'string', 'max:255'],
            'valor' => ['required', 'numeric', 'min:0'],
            'vencimento' => ['nullable', 'date'],
            'status' => ['nullable', 'string', 'max:30'],
        ]);

        $payload['status'] = $payload['status'] ?? 'pendente';

        $id = DB::table('financeiro_contas_receber')->insertGetId($payload);
        $item = DB::table('financeiro_contas_receber')->where('id', $id)->first();

        return response()->json($item, 201);
    }

    public function storeContaPagar(Request $request)
    {
        if (!Schema::hasTable('financeiro_contas_pagar')) {
            return response()->json(['message' => 'Tabela financeiro_contas_pagar nao encontrada.'], 422);
        }

        $payload = $request->validate([
            'fornecedor' => ['nullable', 'string', 'max:150'],
            'descricao' => ['required', 'string', 'max:255'],
            'valor' => ['required', 'numeric', 'min:0'],
            'vencimento' => ['nullable', 'date'],
            'status' => ['nullable', 'string', 'max:30'],
        ]);

        $payload['status'] = $payload['status'] ?? 'pendente';

        $id = DB::table('financeiro_contas_pagar')->insertGetId($payload);
        $item = DB::table('financeiro_contas_pagar')->where('id', $id)->first();

        return response()->json($item, 201);
    }

    public function storeMovimentacao(Request $request)
    {
        if (!Schema::hasTable('financeiro_movimentacoes')) {
            return response()->json(['message' => 'Tabela financeiro_movimentacoes nao encontrada.'], 422);
        }

        $payload = $request->validate([
            'tipo' => ['required', 'string', 'in:entrada,saida'],
            'descricao' => ['required', 'string', 'max:255'],
            'valor' => ['required', 'numeric', 'min:0'],
            'data' => ['nullable', 'date'],
            'status' => ['nullable', 'string', 'max:30'],
        ]);

        $payload['status'] = $payload['status'] ?? 'confirmado';

        $id = DB::table('financeiro_movimentacoes')->insertGetId($payload);
        $item = DB::table('financeiro_movimentacoes')->where('id', $id)->first();

        return response()->json($item, 201);
    }
}
