<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AgendaEvento extends Model
{
    protected $table = 'agenda_eventos';

    protected $fillable = [
        'titulo',
        'descricao',
        'inicio_em',
        'fim_em',
        'categoria',
        'status',
        'prioridade',
        'localizacao',
        'notas',
        'tags',
        'relacionados',
        'visibilidade',
        'owner_id',
        'created_by_id',
        'updated_by_id',
        'usuario_telefone',
        'cliente_id',
        'cliente_nome',
        'cliente_telefone',
        'cliente_email',
        'lembrete_minutos',
        'lembrete_sms_usuario',
        'lembrete_sms_cliente',
    ];

    protected $casts = [
        'inicio_em' => 'datetime',
        'fim_em' => 'datetime',
        'tags' => 'array',
        'relacionados' => 'array',
        'lembrete_minutos' => 'integer',
        'lembrete_sms_usuario' => 'boolean',
        'lembrete_sms_cliente' => 'boolean',
    ];

    public function organizador()
    {
        return $this->belongsTo(Usuario::class, 'owner_id');
    }

    public function criadoPor()
    {
        return $this->belongsTo(Usuario::class, 'created_by_id');
    }

    public function atualizadoPor()
    {
        return $this->belongsTo(Usuario::class, 'updated_by_id');
    }

    public function participantes()
    {
        return $this->hasMany(AgendaEventoParticipante::class, 'evento_id');
    }

    public function mensagens()
    {
        return $this->hasMany(AgendaEventoMensagem::class, 'evento_id');
    }

    public function lembretes()
    {
        return $this->hasMany(AgendaEventoLembrete::class, 'evento_id');
    }

    public function cliente()
    {
        return $this->belongsTo(Cliente::class, 'cliente_id');
    }
}
