<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AgendaEventoMensagem extends Model
{
    protected $table = 'agenda_evento_mensagens';

    protected $fillable = [
        'evento_id',
        'usuario_id',
        'mensagem',
    ];

    public function evento()
    {
        return $this->belongsTo(AgendaEvento::class, 'evento_id');
    }

    public function usuario()
    {
        return $this->belongsTo(Usuario::class, 'usuario_id');
    }
}
