<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AnaliseRisco extends Model
{
    protected $fillable = ['politica_risco_id', 'score', 'nivel', 'status'];

    public function politicaRisco()
    {
        return $this->belongsTo(PoliticaRisco::class);
    }

    public function propostaAnaliseRiscos()
    {
        return $this->hasMany(PropostaAnaliseRisco::class);
    }

    public function alertaRiscos()
    {
        return $this->hasMany(AlertaRisco::class);
    }

    public function historicosCompliance()
    {
        return $this->hasMany(HistoricoCompliance::class);
    }

}

