<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;

class FinanceiroService
{
    public function resumo(): array
    {
        $contasPagar = 0;
        $contasReceber = 0;
        $fluxo = 0;

        if (Schema::hasTable('financeiro_contas_pagar')) {
            $contasPagar = (float) DB::table('financeiro_contas_pagar')
                ->whereNotIn('status', ['pago', 'cancelado'])
                ->sum('valor');
        }

        if (Schema::hasTable('financeiro_contas_receber')) {
            $contasReceber = (float) DB::table('financeiro_contas_receber')
                ->whereNotIn('status', ['recebido', 'cancelado'])
                ->sum('valor');
        }

        if (Schema::hasTable('financeiro_movimentacoes')) {
            $totals = DB::table('financeiro_movimentacoes')
                ->selectRaw("SUM(CASE WHEN tipo = 'entrada' THEN valor ELSE 0 END) as entradas")
                ->selectRaw("SUM(CASE WHEN tipo = 'saida' THEN valor ELSE 0 END) as saidas")
                ->first();
            $entradas = isset($totals->entradas) ? (float) $totals->entradas : 0;
            $saidas = isset($totals->saidas) ? (float) $totals->saidas : 0;
            $fluxo = $entradas - $saidas;
        } else {
            $fluxo = $contasReceber - $contasPagar;
        }

        return [
            'contas_pagar' => $contasPagar,
            'contas_receber' => $contasReceber,
            'fluxo' => $fluxo,
        ];
    }
}
