<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'role')) {
                $table->string('role', 50)->default('operacional')->after('password');
            }
            if (!Schema::hasColumn('users', 'perfil_acesso_id')) {
                $table->unsignedBigInteger('perfil_acesso_id')->nullable()->after('role');
            }
            if (!Schema::hasColumn('users', 'ativo')) {
                $table->boolean('ativo')->default(true)->after('perfil_acesso_id');
            }
        });
    }

    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['role', 'perfil_acesso_id', 'ativo']);
        });
    }
};
