<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('proposta_documentos')) {
            return;
        }

        Schema::table('proposta_documentos', function (Blueprint $table) {
            if (!Schema::hasColumn('proposta_documentos', 'tipo')) {
                $table->string('tipo', 120)->nullable();
            }
            if (!Schema::hasColumn('proposta_documentos', 'arquivo')) {
                $table->string('arquivo', 255)->nullable();
            }
            if (!Schema::hasColumn('proposta_documentos', 'status')) {
                $table->string('status', 40)->nullable();
            }
            if (!Schema::hasColumn('proposta_documentos', 'created_at')) {
                $table->timestamp('created_at')->nullable();
            }
            if (!Schema::hasColumn('proposta_documentos', 'updated_at')) {
                $table->timestamp('updated_at')->nullable();
            }
        });
    }

    public function down(): void
    {
        if (!Schema::hasTable('proposta_documentos')) {
            return;
        }

        Schema::table('proposta_documentos', function (Blueprint $table) {
            if (Schema::hasColumn('proposta_documentos', 'tipo')) {
                $table->dropColumn('tipo');
            }
            if (Schema::hasColumn('proposta_documentos', 'arquivo')) {
                $table->dropColumn('arquivo');
            }
            if (Schema::hasColumn('proposta_documentos', 'status')) {
                $table->dropColumn('status');
            }
            if (Schema::hasColumn('proposta_documentos', 'created_at')) {
                $table->dropColumn('created_at');
            }
            if (Schema::hasColumn('proposta_documentos', 'updated_at')) {
                $table->dropColumn('updated_at');
            }
        });
    }
};
