import { createRouter, createWebHistory } from 'vue-router'
import DashboardLayout from '@/layouts/DashboardLayout.vue'
import Login from '@/pages/Login.vue'
import Dashboard from '@/pages/Dashboard.vue'
import Leads from '@/pages/Leads.vue'
import LeadDetalhes from '@/pages/LeadDetalhes.vue'

const routes = [
  { path: '/login', name: 'login', component: Login },
  {
    path: '/',
    component: DashboardLayout,
    children: [
      { path: '', name: 'dashboard', component: Dashboard },
      { path: 'leads', name: 'leads', component: Leads },
      { path: 'leads/:id', name: 'lead-detalhes', component: LeadDetalhes, props: true },
    ],
  },
]

const router = createRouter({
  history: createWebHistory(),
  routes,
})

export default router
