<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Usuario;

class UsuarioController extends Controller
{
    public function index()
    {
        return response()->json(Usuario::with('perfil')->paginate());
    }

    public function store(Request $request)
    {
        $usuario = Usuario::create($request->all());
        return response()->json($usuario, 201);
    }

    public function show(string $id)
    {
        return response()->json(Usuario::with('perfil')->findOrFail($id));
    }

    public function update(Request $request, string $id)
    {
        $usuario = Usuario::findOrFail($id);
        $usuario->update($request->all());
        return response()->json($usuario);
    }

    public function destroy(string $id)
    {
        Usuario::findOrFail($id)->delete();
        return response()->json(['message' => 'Usu?rio removido']);
    }
}
