<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ContratoCredito extends Model
{
    use HasFactory;

    protected $fillable = [
        'proposta_id',
        'status',
        'valor',
        'prazo',
        'data_assinatura',
    ];

    public function proposta()
    {
        return $this->belongsTo(PropostaCredito::class, 'proposta_id');
    }

    public function garantias()
    {
        return $this->hasMany(ContratoGarantia::class, 'contrato_id');
    }

    public function clausulas()
    {
        return $this->hasMany(ContratoClausula::class, 'contrato_id');
    }

    public function assinaturas()
    {
        return $this->hasMany(ContratoAssinatura::class, 'contrato_id');
    }

    public function indexadores()
    {
        return $this->hasMany(ContratoIndexador::class, 'contrato_id');
    }

    public function parcelas()
    {
        return $this->hasMany(ParcelaContrato::class, 'contrato_id');
    }
}
