<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PessoaJuridica extends Model
{
    use HasFactory;

    protected $fillable = [
        'razao_social',
        'nome_fantasia',
        'cnpj',
        'inscricao_estadual',
        'segmento',
    ];

    public function enderecos()
    {
        return $this->morphMany(Endereco::class, 'enderecavel');
    }

    public function contatos()
    {
        return $this->morphMany(Contato::class, 'contatavel');
    }

    public function socios()
    {
        return $this->hasMany(Socio::class, 'pessoa_juridica_id');
    }

    public function propostas()
    {
        return $this->hasMany(PropostaCredito::class, 'pessoa_juridica_id');
    }
}
