<?php

namespace App\Services;

use App\Models\Imovel;

class ImovelService
{
    public function list()
    {
        return Imovel::with(['documentacoes','fotos'])->latest()->paginate();
    }

    public function find(string $id)
    {
        return Imovel::with(['documentacoes','fotos'])->findOrFail($id);
    }

    public function create(array $data)
    {
        return Imovel::create($data);
    }

    public function update(string $id, array $data)
    {
        $imovel = Imovel::findOrFail($id);
        $imovel->update($data);
        return $imovel;
    }

    public function delete(string $id): void
    {
        Imovel::findOrFail($id)->delete();
    }
}
