<?php

namespace App\Services;

use App\Models\Lead;
use App\Models\PropostaCredito;
use App\Models\Usuario;
use Illuminate\Support\Facades\DB;

class LeadService
{
    public function list()
    {
        return Lead::with(['responsavel'])->latest()->paginate();
    }

    public function find(string $id)
    {
        return Lead::with(['responsavel'])->findOrFail($id);
    }

    public function create(array $data)
    {
        return Lead::create($data);
    }

    public function update(string $id, array $data)
    {
        $lead = Lead::findOrFail($id);
        $lead->update($data);
        return $lead;
    }

    public function delete(string $id): void
    {
        Lead::findOrFail($id)->delete();
    }

    public function updateStatus(string $id, string $status)
    {
        $lead = Lead::findOrFail($id);
        $lead->status = $status;
        $lead->save();
        return $lead;
    }

    public function assignResponsavel(string $id, string $usuarioId)
    {
        $lead = Lead::findOrFail($id);
        $lead->responsavel_id = $usuarioId;
        $lead->save();
        return $lead;
    }

    public function convertToProposta(string $id)
    {
        $lead = Lead::findOrFail($id);
        return DB::transaction(function () use ($lead) {
            $proposta = PropostaCredito::create([
                'lead_id' => $lead->id,
                'status' => 'em_analise'
            ]);
            $lead->status = 'convertido';
            $lead->save();
            return $proposta;
        });
    }
}
