<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ContratoCredito extends Model
{
    protected $table = 'contratos_credito';

    public $timestamps = false;

    protected $fillable = [
        'cliente_id',
        'proposta_id',
        'valor_liberado',
        'prazo_meses',
        'taxa_juros',
        'indexador_id',
        'status_contrato_id',
        'data_assinatura',
    ];

    public function propostaCredito()
    {
        return $this->belongsTo(PropostaCredito::class, 'proposta_id');
    }

    public function cliente()
    {
        return $this->belongsTo(Cliente::class, 'cliente_id');
    }

    public function imovelGarantias()
    {
        return $this->hasMany(ContratoGarantia::class, 'contrato_id');
    }

    public function contratoGarantias()
    {
        return $this->hasMany(ContratoGarantia::class, 'contrato_id');
    }

    public function contratoClausulas()
    {
        return $this->hasMany(ContratoClausula::class, 'contrato_id');
    }

    public function contratoAssinaturas()
    {
        return $this->hasMany(ContratoAssinatura::class, 'contrato_id');
    }

    public function contratoIndexadors()
    {
        return $this->hasMany(ContratoIndexador::class, 'contrato_id');
    }

    public function contratoDocumentos()
    {
        return $this->hasMany(ContratoDocumento::class, 'contrato_id');
    }

    public function solicitacoesDocumentos()
    {
        return $this->hasMany(ContratoDocumentoSolicitacao::class, 'contrato_id');
    }

    public function processoJuridicos()
    {
        return $this->hasMany(ProcessoJuridico::class, 'contrato_id');
    }

    public function contasReceber()
    {
        return $this->hasMany(ContaReceber::class, 'contrato_id');
    }

    public function parcelasContrato()
    {
        return $this->hasMany(ParcelaContrato::class, 'contrato_id');
    }

    public function renegociacoes()
    {
        return $this->hasMany(Renegociacao::class, 'contrato_id');
    }

}

