<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PropostaCredito extends Model
{
    protected $table = 'propostas_credito';

    protected $fillable = [
        'cliente_id',
        'valor_solicitado',
        'prazo_meses',
        'finalidade',
        'status_proposta_id',
        'documentacao_at',
        'vistoria_at',
        'avaliacao_at',
        'comite_at',
    ];

    public function cliente()
    {
        return $this->belongsTo(Cliente::class, 'cliente_id');
    }

    public function propostaDocumentos()
    {
        return $this->hasMany(PropostaDocumento::class, 'proposta_id');
    }

    public function solicitacoesDocumentos()
    {
        return $this->hasMany(PropostaDocumentoSolicitacao::class, 'proposta_id');
    }

    public function propostaScoreInternos()
    {
        return $this->hasMany(PropostaScoreInterno::class, 'proposta_id');
    }

    public function propostaAnaliseRiscos()
    {
        return $this->hasMany(PropostaAnaliseRisco::class, 'proposta_id');
    }

    public function historicosStatus()
    {
        return $this->hasMany(PropostaHistoricoStatus::class, 'proposta_id');
    }

    public function contratoCreditos()
    {
        return $this->hasMany(ContratoCredito::class, 'proposta_id');
    }

    public function imoveis()
    {
        return $this->belongsToMany(Imovel::class, 'proposta_imovel', 'proposta_id', 'imovel_id');
    }

}

