<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class PropostaDocumentoSolicitacao extends Model
{
    protected $table = 'proposta_documento_solicitacoes';

    protected $fillable = [
        'proposta_id',
        'token',
        'canal',
        'destinatario',
        'tipo_cliente',
        'nome_cliente',
        'objetivo',
        'status',
    ];

    public function propostaCredito()
    {
        return $this->belongsTo(PropostaCredito::class, 'proposta_id');
    }
}
