<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Vistoria extends Model
{
    protected $fillable = ['imovel_id', 'vistoriador_id', 'data_vistoria', 'status'];

    public function imovel()
    {
        return $this->belongsTo(Imovel::class);
    }

    public function vistoriador()
    {
        return $this->belongsTo(Usuario::class);
    }

    public function itemVistorias()
    {
        return $this->hasMany(ItemVistoria::class);
    }

    public function vistoriaFotos()
    {
        return $this->hasMany(VistoriaFoto::class);
    }

}

