<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('pessoas_fisicas')) {
            return;
        }

        Schema::create('pessoas_fisicas', function (Blueprint $table) {
            $table->id();
            $table->string('nome');
            $table->string('cpf', 20)->unique();
            $table->string('rg', 30)->nullable();
            $table->date('data_nascimento')->nullable();
            $table->string('estado_civil', 50)->nullable();
            $table->decimal('renda_mensal', 15, 2)->nullable();
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('pessoas_fisicas');
    }
};
