<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('leads')) {
            return;
        }

        $columns = Schema::getColumnListing('leads');

        Schema::table('leads', function (Blueprint $table) use ($columns) {
            if (!in_array('external_source', $columns, true)) {
                $table->string('external_source', 80)->nullable()->after('origem');
            }
            if (!in_array('external_id', $columns, true)) {
                $table->unsignedBigInteger('external_id')->nullable()->after('external_source');
            }
            if (!in_array('validated_at', $columns, true)) {
                $table->timestamp('validated_at')->nullable()->after('external_id');
            }
            if (!in_array('tipo_solicitacao', $columns, true)) {
                $table->string('tipo_solicitacao', 40)->nullable()->after('validated_at');
            }
        });

        if (!in_array('external_source', $columns, true) || !in_array('external_id', $columns, true)) {
            Schema::table('leads', function (Blueprint $table) {
                $table->index(['external_source', 'external_id'], 'leads_external_source_id_index');
            });
        }
    }

    public function down(): void
    {
        if (!Schema::hasTable('leads')) {
            return;
        }

        Schema::table('leads', function (Blueprint $table) {
            $table->dropIndex('leads_external_source_id_index');
            $table->dropColumn(['external_source', 'external_id', 'validated_at', 'tipo_solicitacao']);
        });
    }
};
