<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (Schema::hasTable('proposta_documento_solicitacoes')) {
            return;
        }

        Schema::create('proposta_documento_solicitacoes', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('proposta_id');
            $table->string('token', 64)->unique();
            $table->string('canal', 20);
            $table->string('destinatario', 255)->nullable();
            $table->string('tipo_cliente', 2)->nullable();
            $table->string('nome_cliente', 160)->nullable();
            $table->string('objetivo', 255)->nullable();
            $table->string('status', 40)->default('pendente');
            $table->timestamps();

            $table->index('proposta_id');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('proposta_documento_solicitacoes');
    }
};
