<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        if (!Schema::hasTable('users')) {
            return;
        }

        if (!Schema::hasColumn('users', 'telefone')) {
            Schema::table('users', function (Blueprint $table) {
                $table->string('telefone', 30)->nullable();
            });
        }
    }

    public function down(): void
    {
        if (!Schema::hasTable('users')) {
            return;
        }

        if (Schema::hasColumn('users', 'telefone')) {
            Schema::table('users', function (Blueprint $table) {
                $table->dropColumn('telefone');
            });
        }
    }
};
